Public Class StructuresAndEnums


    Public Enum RandomizationMethods

        ''' <summary>
        ''' A new randomization will be created from the truly random bitstream at RANDOM.ORG. This is probably what you want in most cases.
        ''' </summary>
        ''' <remarks></remarks>
        Random = 0

        ''' <summary>
        ''' Determine the randomization in a deterministic fashion from a large pool of pregenerated random bits.
        ''' Because the numbers are produced in a deterministic fashion, specifying an id basically uses RANDOM.ORG as a pseudo-random number generator.
        ''' </summary>
        ''' <remarks></remarks>
        IdentifierBased = 1

        ''' <summary>
        ''' This method is similar to IdentifierBased; it allows the randomization to be based on one of the daily
        ''' pregenerated files. This method must refer to one of the dates for which files exist, so it must be a day in the past.
        ''' </summary>
        ''' <remarks></remarks>
        DateBased = 2

    End Enum


    Public Structure ValueRange

        Public MinValue As Integer
        Public MaxValue As Integer

        Public Sub New(ByVal MinValue As Integer, ByVal MaxValue As Integer)
            Me.MinValue = MinValue
            Me.MaxValue = MaxValue
        End Sub

    End Structure


End Class
